--------------------------------------------------------------------
--            SymCACP Script Module 2       
-- Symmetrical CA Control Panel   symCACPscript-1
--------------------------------------------------------------------
--  P. Rendell   07/08/2020
--------------------------------------------------------------------
-- start section with "SCRIPT nnn" nnn = module name
-- end section with "SCRIPTEND"
-- command "RUN" runs the script
-- command "buildParm cmn op parms" builds a command line returning OK or Fail code
-- This passes:
--     "cmd" text
--     "op" text = "=" or ":" or something new
--      and "parms" which is a text list of parameters

--------------------------------------------------------------------
--------------------------------------------------------------------
local m = {}		-- class table
local segName = {}
local segModule = {}
local seglines = {}
local segColonList = {}
local comProcs = {}	-- common Procedures
local noSegs = 0
local g = golly()
local gr 
--local gr = require("buildUni") 
local gs 
--local gs = require("search") 
local runList = {}
local makeScriptList
--------------------------------------------------------------------------------
   function m.init(logFile, util, modBuildUni, modSearch)
      m.report = util.report			-- procedure in controlPanel
      comProcs.GobalSwitch = util.GobalSwitch   -- procedure GobalSwitch in controlPanel
      comProcs.report = util.report		-- procedure reporter in controlPanel
      comProcs.makeList = util.makeList		-- procedure in controlPanel
      comProcs.makeString = util.makeString	-- procedure in controlPanel
      comProcs.newLog = util.newLog			-- procedure in controlPanel
      comProcs.oldLog = util.oldLog			-- procedure in controlPanel
      comProcs.note = util.note			-- procedure in controlPanel
      comProcs.bool2txt = util.bool2txt		-- procedure in controlPanel
      
      m.logFile = logFile
      m.util = util
      gr = modBuildUni
      gs = modSearch
      m.cnt = 0
      m.linesDone = {}
   end
--------------------------------------------------------------------------------
   function split(str)
      a={}
      for word in string.gmatch(str, "[^,%s]+") do
         a[#a+1] = word
      end
      return a
   end
--------------------------------------------------------------------------------
   function splitKey(str)
      a={}
      for word in string.gmatch(str, "[^:%s]+") do
         a[#a+1] = word
      end
      return a
   end
--------------------------------------------------------------------------------
   function addList(listA, listB)
      local found
      for i,el1 in pairs(listB) do
         found = false
         for j,el2 in pairs(listA) do
            found = (el1 == el2)
            if found then
               break
            end
         end
         if not found then
            listA[#listA+1] = el1
         end
      end
   end
--------------------------------------------------------------------------------
--==============================================================================
-- common Procedures
--------------------------------------------------------------------------------
   function comProcs.checkRule(rule)
      return true
   end
   
--------------------------------------------------------------------------------
   function comProcs.checkSeed(seed)
      return true
   end
--------------------------------------------------------------------------------
   function comProcs.LogScript(segmentNo)
       m.logFile:write(makeScriptList(segmentNo)..'\n')
       m.logFile:write(m.report.getReport(false)..'\n')
   end
   
        
   
--==============================================================================
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
   makeScriptList = function(segmentNo)
      local txt = 'no script loaded'
      local pageW = 50
      if (segmentNo > 0) then
         txt = 'Script '..m.util.reFormat(scriptFile,pageW)..'\n'
         txt = txt..'\n'..segName[segmentNo]..'\n\n'
         for name, v in pairs(segColonList[segmentNo]) do
	    txt = txt..m.util.reFormat(name..': '..m.util.makeString(segColonList[segmentNo][name], ", "), pageW)..'\n'
	 end
         for i, line in pairs(seglines[segmentNo]) do
	    txt = txt..m.util.reFormat(line[2]..line[3]..line[4][1], pageW)..'\n'
	 end
      end
      return txt
   end
   --------------------------------------------------------------------------------
      
   function m.ScriptLoaded()
      return(noSegs>0)
   end
   --------------------------------------------------------------------------------
      
   function m.doScriptList()
      for segNo = 1,noSegs do
         local reportTxt = m.report.getReport(false)
         local scriptList = makeScriptList(segNo)
         if #reportTxt > 0 then
            m.util.note(scriptList..'\n\n'..reportTxt)
         else
            m.util.note(scriptList)
         end         
      end
      if (noSegs < 1) then
        m.util.note('No Script file Loaded')
      end
   end
   
   --------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------
function buildParm(lineNo, cmd, op, parms, segNo)
   local res = true
   local checkedParms = parms
   if (op == "=") then
      value = parms[1]
      if (segModule[segNo].equalList[cmd]) then
         if (segModule[segNo].equalList[cmd][1] == 'd') then
            value = tonumber(parms[1])
            if (not value) then
               m.report.collect("line "..lineNo.." invalid number "..cmd.." = "..parms[1].."\n",false, segNo)
            end
         elseif (segModule[segNo].equalList[cmd][1] == 't') then
            value = parms[1]
         elseif (segModule[segNo].equalList[cmd][1] == 'g') then
            value = parms[1]:upper():sub(1,2)
            if not ((value == 'D') or (value == 'O') or (value == 'B') or (value == 'R')) then
	       m.report.collect("line "..lineNo..'Geography '..parms[1]..' not recognised Randon used',true, segNo)
	       value = 'R'
	    end
         elseif (segModule[segNo].equalList[cmd][1] == 'l') then
            value = parms[1]:upper() == 'TRUE'
	 end
         segModule[segNo].buildParmVal(cmd, value, segNo)
      else
         m.report.collect("line "..lineNo.." unknown command "..cmd.." = \n",true, segNo)
      end
   elseif (op == ":") then
      if (segModule[segNo].colonList[cmd]) then
         if (segModule[segNo].colonList[cmd][1] == 'r') then
            for i, rule in pairs(parms) do
               if not comProcs.checkRule(rule) then
                  m.report.collect("line "..lineNo.." invalid rule "..rule.." = \n",false, segNo)
                  res = false
               end
            end
         elseif (segModule[segNo].colonList[cmd][1] == 's') then
            for i, seed in ipairs(parms) do
               if not comProcs.checkSeed(seed) then
                  m.report.collect("line "..lineNo.." invalid seed "..seed.." = \n",false, segNo)
                  res = false
               end
            end
         elseif (segModule[segNo].colonList[cmd][1] == 'd') then
            for i, rule in pairs(parms) do
               checkedParms[i] = tonumber(parms[i])
               if (not checkedParms[i]) then
                  m.report.collect("line "..lineNo.." invalid number "..cmd.." = "..parms[i].."\n",false, segNo)
               end
            end
         elseif (segModule[segNo].colonList[cmd][1] == 'l') then
            for i, val in pairs(parms) do
               checkedParms[i] = val:upper() == 'TRUE'
            end
         end
         segModule[segNo].buildParmLst(cmd, checkedParms, segNo)
      else
         m.report.collect("line "..lineNo.." unknown command "..cmd.." : \n",true, segNo)
      end
   else
      m.report.collect("line "..lineNo.." unknown operator "..op.." \n",true, segNo)
   end
   return res
end

------------------------------------------------------------------------------------------------
function m.validateScript()
   local res = true
   for i,cmd in ipairs(segModule[noSegs].colonList) do
      if (segModule[noSegs].colonList[cmd][2] == "R") and not scriptFileData[cmd] then
         res = false
         m.report.collect(scriptType.." missing "..cmd.." \n",false, noSegs)
      end
   end
   for i,cmd in ipairs(segModule[noSegs].equalList) do
      if (segModule[noSegs].equalList[cmd][2] == "R") and not scriptFileData[cmd] then
         res = false
         m.report.collect(scriptType.." missing "..cmd.." \n",false, noSegs)
      end
   end
   return res and segModule[noSegs].validateScript()
end

------------------------------------------------------------------------------------------------
   
   local function scriptStartLoad(line)
      noSegs = noSegs + 1
      segName[noSegs] = line:upper():match("^SCRIPT%s+([^%s]+)")
      m.logFile:write("scriptStartLoad "..line.." seg "..noSegs.." name "..segName[noSegs]..'\n')
      segModule[noSegs] = require(segName[noSegs])
      m.logFile:write("scriptStartLoad- "..line.." seg "..noSegs.." name "..segName[noSegs]..'\n')
      m.logFile:flush()
      segModule[noSegs].init(m.logFile, comProcs)
      seglines[noSegs] = {}
      segColonList[noSegs] = {}
      m.report.getReport(true, noSegs)  -- clear reoprt
      m.logFile:write("Segment "..segName[noSegs]..' Found\n')
   end
   --------------------------------------------------------------------------------
   
   local function scriptEndLoad()
      return m.validateScript()
   end
   --------------------------------------------------------------------------------
   
   function m.ScriptLoad(scriptFileName, lines)
      scriptFile = scriptFileName
      m.logFile:write("loading script "..scriptFile.."\n")
      local name
      local value
      local segFound = false
      noSegs = 0
      for lineNo = 1, #lines do
         local line = lines[lineNo]
         m.logFile:write(line.."\n")
         if line:upper():find("^SCRIPT%s+[^%s]+") then
            if (noSegs>0) and segFound then
               m.report.collect('line '..line..' missing SCRIPTEND assumed',true, noSegs)
               scriptEndLoad()
            end
            scriptStartLoad(line)
            segFound = true
         elseif line:upper():find("^SCRIPTEND") then
            scriptEndLoad()
            segFound = false
         elseif (segFound) then
            if line:find('[^%s]%s*=%s*[^%s]') then
               name = line:upper():match "^%s*(.-)%s*="
               value = line:match "=%s*(.-)%s*$"
               buildParm(lineNo, name, "=", {value}, noSegs)
               table.insert(seglines[noSegs],{lineNo, name, "=", {value} })
            elseif line:find('[^%s]%s*:%s*[^%s]') then
               name = line:upper():match "^%s*(.-)%s*:"
               value = line:upper():match ":%s*(.-)%s*$"
               buildParm(lineNo, name, ":",  m.util.makeList(value), noSegs)
               if not segColonList[noSegs][name] then
                  segColonList[noSegs][name] = {}
               end
               addList(segColonList[noSegs][name], m.util.makeList(value))
            end
         end
      end
      if (noSegs>0) and segFound then
	 m.report.collect(' missing SCRIPTEND assumed',true, noSegs)
         scriptEndLoad()
      end
      m.doScriptList()
   end
   --------------------------------------------------------------------------------
   
   function m.doScriptLoad()
      -- veryfily all lines
      -- then return to sections and act on them one after another
      g.show("loading script")
      scriptFile = g.opendialog('Script File')
--      scriptFile = '../SymCACPisland-W-Script.txt'
      if scriptFile then
         local lines = {}
         local f = io.open(scriptFile, "r")
         if(f) then
            local line = f:read("*line")
            while line do
               lines[#lines+1] = line
               line = f:read("*line")
            end
         end
         m.ScriptLoad(scriptFile, lines)
      end
      m.logFile:flush()
   end
   --------------------------------------------------------------------------------
      
   function m.doScriptRun(verify)
      local res = true
      m.logFile:write('doScriptRun script\n')
      
      if (noSegs > 0) then
         for seg = 1, noSegs do
            m.logFile:write('Starting '..segName[noSegs]..'\n')
            g.show('Starting '..segName[noSegs])
            segModule[noSegs].init(m.logFile, comProcs)
            for name, value in pairs(segColonList[seg]) do
               res = res and buildParm(0, name, ":", segColonList[seg][name], seg)
	    end
	    for i, line in pairs(seglines[seg]) do
	       res = res and buildParm(line[1], line[2], line[3], line[4], seg)
	    end
	    res = res and segModule[noSegs].validateScript()
	    if (res) then
	       m.logFile:write("Segment "..segName[seg]..' Starting\n')
	       segModule[noSegs].run(seg)
	       m.logFile:write("Segment "..segName[seg]..' Finished\n')
	    else
	       m.logFile:write("Segment "..segName[seg]..' not run due to errors\n')
	    end
         end
      else
        m.util.note('No Script file Loaded')
      end
      m.logFile:flush()
   end
--------------------------------------------------------------------------------
   function m.saveResults(resType)
   end
   --------------------------------------------------------------------------------
      
   
return m

--------------------------------------------------------------------
--                      	END OF FILE
--------------------------------------------------------------------
